VERSION 2.00
Begin Form frmMain 
   Caption         =   "Generic SDI Application"
   ClientHeight    =   3450
   ClientLeft      =   885
   ClientTop       =   1980
   ClientWidth     =   7770
   Height          =   4140
   Icon            =   SDIFRAME.FRX:0000
   Left            =   825
   LinkTopic       =   "Form1"
   ScaleHeight     =   3450
   ScaleWidth      =   7770
   Top             =   1350
   Width           =   7890
   Begin CommonDialog dlgCommon 
      Left            =   120
      Top             =   2880
   End
   Begin TextBox txtEdit 
      Height          =   2775
      HideSelection   =   0   'False
      Left            =   -30
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   0
      Width           =   7785
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnuTools 
      Caption         =   "&Tools"
      Begin Menu mnuToolsSpellEdit 
         Caption         =   "Spell Check &Edit Field"
      End
      Begin Menu mnuToolsSpellBuffer 
         Caption         =   "Spell Check &Buffer..."
      End
      Begin Menu mnuToolsSpellFile 
         Caption         =   "Spell Check &File..."
      End
      Begin Menu mnuToolsSpellWord 
         Caption         =   "Spell Check &Word..."
      End
      Begin Menu mnuToolsSep1 
         Caption         =   "-"
      End
      Begin Menu mnuToolsImport 
         Caption         =   "&Import Words..."
      End
      Begin Menu mnuToolsExport 
         Caption         =   "&Export Words..."
      End
      Begin Menu mnuToolsSep2 
         Caption         =   "-"
      End
      Begin Menu mnuToolsSetup 
         Caption         =   "SpellChecker &Setup..."
      End
      Begin Menu mnuToolsAbout 
         Caption         =   "&About SpellChecker..."
      End
   End
End

Option Explicit

Sub Form_Activate ()

    txtEdit.SetFocus

End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)
	
    mnuFileExit_Click

End Sub

Sub Form_Resize ()

    txtEdit.Move 0, 0, Me.ScaleWidth, Me.ScaleHeight
    
End Sub

Sub mnuFileExit_Click ()

    Unload frmMain

    ' Terminate the application
    End

End Sub

Sub mnuToolsAbout_Click ()

    SpellAbout frmMain.hWnd

End Sub

Sub mnuToolsExport_Click ()

    Dim liRc As Integer
    Dim lsQualName As String
    Dim lsFileName As String
    Dim lsDictionary As String


    If SelectFile(frmMain.dlgCommon, DLG_FILE_SAVE, "Export Words", "txt", "Text Files (*.txt)|*.txt|All files (*.*)|*.*", lsQualName, lsFileName) = IDOK Then
	' User selected to export

	liRc = GetPrivateProfileString("Application", "Dictionary", "UK.DIC", lsDictionary, 100, "GENERIC.INI")

	liRc = SpellLoadDictionary()
	If liRc = 0 Then liRc = SpellExportWords(lsQualName)

	If liRc = 0 Then
	    MsgBox "Export completed successfully", MB_OK + MB_ICONEXCLAMATION, GetAppName()
	Else
	    SpellCheckError frmMain.hWnd, liRc
	End If

	SpellUnloadDictionary
    End If

End Sub

Sub mnuToolsImport_Click ()

    Dim liRc As Integer
    Dim lsQualName As String
    Dim lsFileName As String
    Dim lsDictionary As String


    If SelectFile(frmMain.dlgCommon, DLG_FILE_OPEN, "Import Words", "txt", "Text Files (*.txt)|*.txt|All files (*.*)|*.*", lsQualName, lsFileName) = IDOK Then
	' User selected to export

	liRc = GetPrivateProfileString("Application", "Dictionary", "UK.DIC", lsDictionary, 100, "GENERIC.INI")

	liRc = SpellLoadDictionary()
	If liRc = 0 Then liRc = SpellImportWords(lsQualName)

	If liRc = 0 Then
	    MsgBox "Import completed successfully", MB_OK + MB_ICONEXCLAMATION, GetAppName()
	Else
	    SpellCheckError frmMain.hWnd, liRc
	End If

	SpellUnloadDictionary
    End If

End Sub

Sub mnuToolsSetup_Click ()

    SpellSetup frmMain.hWnd

End Sub

Sub mnuToolsSpellBuffer_Click ()

    frmBuffer.Show 1
    Unload frmBuffer

End Sub

Sub mnuToolsSpellEdit_Click ()

    Dim liRc As Integer
    Dim lsDictionary As String


    liRc = GetPrivateProfileString("Application", "Dictionary", "UK.DIC", lsDictionary, 100, "GENERIC.INI")

    liRc = SpellLoadDictionary()
    If liRc = 0 Then liRc = SpellCheckEdit(frmMain.hWnd, frmMain.txtEdit.hWnd)

    SpellCheckError frmMain.txtEdit.hWnd, liRc

    SpellUnloadDictionary

End Sub

Sub mnuToolsSpellFile_Click ()

    Dim liRc As Integer
    Dim lsQualName As String
    Dim lsFileName As String
    Dim lsDictionary As String


    If SelectFile(frmMain.dlgCommon, DLG_FILE_OPEN, "Spell Check File", "txt", "Text Files (*.txt)|*.txt|All files (*.*)|*.*", lsQualName, lsFileName) = IDOK Then
	' User selected to spell check the file

	liRc = GetPrivateProfileString("Application", "Dictionary", "UK.DIC", lsDictionary, 100, "GENERIC.INI")

	liRc = SpellLoadDictionary()
	If liRc = 0 Then liRc = SpellCheckFile(frmMain.hWnd, lsQualName)

	SpellCheckError frmMain.hWnd, liRc

	SpellUnloadDictionary
    End If

End Sub

Sub mnuToolsSpellWord_Click ()

    frmWord.Show 1
    Unload frmWord

End Sub

